# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 10
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR10_strategy.txt
# LLM Suggested Fallback: D

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Game (Rounds 1-3)
    if current_round == 1:
        return "C"
    elif current_round == 2:
        return "D"
    elif current_round == 3:
        if len(opp_history) >= 1 and opp_history[1] == "D":
            return "D"
        else:
            return "C"
    
    # Mid Game (Rounds 4-7)
    elif current_round <= 7:
        if len(opp_history) >= 1 and opp_history[-1] == "D":
            return "D"
        elif len(opp_history) >= 2 and opp_history[-1] == "C" and opp_history[-2] == "C":
            return "C"
        else:
            return "D" if random.random() < 0.3 else "C"
    
    # Late Game (Rounds 8-10)
    else:
        if current_round == 10:
            return "D"
        elif sum(1 for move in opp_history if move == "D") > sum(1 for move in opp_history if move == "C"):
            return "D"
        else:
            return "C"